﻿using System;
using System.Windows.Forms;
using RDR2;
using RDR2.UI;
using RDR2.Native;
using RDR2.Math;

namespace HCL_Superpower_04
{
    public class Main : Script
    {
/// //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        Keys SlowTimeKey = Keys.C;  // The key that switches the slow motion, can set to any key beside Shift, Alt or Control. Can set to "Look Behand" key.
        Keys IncreaseSpeed = Keys.F11;  // The key that increases the time flow speed when slow motion is activated.
        Keys DecreaseSpeed = Keys.F12;  // The key that decreases the time flow speed when slow motion is activated.
        float STMutiply = 0.2f;  // The default speed that time flow will be slowed to every time you launch the game.
        float MaxiumSpeed = 0.5f;  // The maxium speed that time flow can be slowed to during slow motion.
        float MininumSpeed = 0.05f;  // The minimum speed that time flow can be slowed to during slow motion.
/// //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        Player player = Game.Player;
        Ped playerPed = Game.Player.Character;
        bool STON = false;
        bool KeyPressed = false;
        int PressedTimer = 0;

        public Main()
        {
            KeyDown += OnKeyDown;
            KeyUp += OnKeyUp;
            Tick += OnTick;
            Interval = 1;
        }

        private void OnTick(object sender, EventArgs e)
        {
            if (KeyPressed && PressedTimer < 13)
            {
                   PressedTimer = PressedTimer + 1;
            }
            if (STON)
            {
                     if (player.IsDead)
                     {
                            STON = false;
                            Function.Call(Hash.SET_TIME_SCALE, 1.0f);
                     }
                     else
                     {
                            Function.Call(Hash.SET_TIME_SCALE, STMutiply);
                            Function.Call(Hash.DRAW_RECT, 0.05, 0.65, 0.00375, 0.15, 200, 255, 200, 255); 
                            Function.Call(Hash.DRAW_RECT, 0.05, 0.65, 0.0025, ((0.15 / MaxiumSpeed) * STMutiply), 0, 55, 0, 255); 
                     }
                     if (Game.IsKeyPressed(IncreaseSpeed) && !Game.IsKeyPressed(DecreaseSpeed) && STMutiply < MaxiumSpeed)
                     {
                                 STMutiply = STMutiply + 0.01f;
                     }
                     if (!Game.IsKeyPressed(IncreaseSpeed) && Game.IsKeyPressed(DecreaseSpeed) && STMutiply > MininumSpeed)
                     {
                                 STMutiply = STMutiply - 0.01f;
                     }
            }
        } 

        private void OnKeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == SlowTimeKey && !e.Shift)
            {
                     KeyPressed = true;
            }
        }

        private void OnKeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == SlowTimeKey && !e.Shift && PressedTimer < 12)
            {
                     if (STON)
                     {
                           STON = false;
	           RDR2.UI.Screen.ShowSubtitle("Slow Time Off");
                           Function.Call(Hash.SET_TIME_SCALE, 1.0f);
                     }
                     else
                     {
                           STON = true;
	           RDR2.UI.Screen.ShowSubtitle("Slow Time On");
                     }
            }
            if (e.KeyCode == SlowTimeKey)
            {
                     KeyPressed = false;
                     PressedTimer = 0;
            }
        }
    }
}
